ORCA/M Asm65816 2.1.0

0001 E5A1                       title 'Kidding' 
0002 E5A1              **********************************************************************
0003 E5A1              *
0004 E5A1              * Kidding.ASM
0005 E5A1              *
0006 E5A1              * Copyright Apple Computer, Inc. 1988
0007 E5A1              * All Rights Reserved
0008 E5A1              *
0009 E5A1              * By Steven Glass
0010 E5A1              *
0011 E5A1              * This is a file that contains code to go out and see what version
0012 E5A1              * of the OS is running and patch a particular version.
0013 E5A1              *
0014 E5A1              * This code is called from inside the QuickDraw Version call.
0015 E5A1              *
0016 E5A1              *
0017 E5A1              **********************************************************************
0018 E5A1
0019 E5A1                       include 'all.macros' 
0020 E5A1                       include '::sys.equs.asm' 
0021 E5A1
0022 E5A1
0023 E5A1              drvr_dib_ptr equ   $00BD24
0024 E5A1
0025 E5A1                       title 'YoveGotToBeKidding' 
0026 E5A1              ****************************************************************
0027 E5A1              *
0028 E5A1              YouveGotToBeKidding PROC EXPORT 
0029 E5A1              *
0030 E5A1              * This patches a bug in the generated driver dibs produced
0031 E5A1              * by version 2.0 of GS/OS.
0032 E5A1              *
0033 E5A1              * This routine is called by QuickDraw version and by InitTextDev.
0034 E5A1              * It is called by QuickDraw version so that it will be executed
0035 E5A1              * right after the OS is loaded the first time.
0036 E5A1              *
0037 E5A1              * This routine is called by InitTextDev because InitTextDev is the
0038 E5A1              * first ROM routine called by the OS after p8 has been run and 
0039 E5A1              * control returns to GS/OS.
0040 E5A1              *
0041 E5A1              *
0042 E5A1              * When there is something to patch, this code looks at 
0043 E5A1              * the dibs and fixes the unit num for 
0044 E5A1              * drive 2 The OS sets it incorrectly to one
0045 E5A1              * and it sould be equal to 2.
0046 E5A1              *
0047 E5A1              * Before trying to do this however, we look at the OS_Flag.
0048 E5A1              * If the OS flag has bit 0 set, then this code has already been
0049 E5A1              * run.
0050 E5A1              *
0051 E5A1              * If the flag is clear, this code has not been run and must
0052 E5A1              * run now.
0053 E5A1              *
0054 E5A1              * If it has not been run, I set the bit and then do the
0055 E5A1              * work.
0056 E5A1              *
0057 E5A1              * We also set the bit 1 of the OS flag if the OS that is running
0058 E5A1              * is the one we have to patch.  This bit is used later
0059 E5A1              * by code in DeskShutdown to see if it is necessary to 
0060 E5A1              * reset bit 0.  Deskshutdown resets bit 0 whenever bit 1 is
0061 E5A1              * set and P8 is active.
0062 E5A1              *
0063 E5A1              * Inputs:
0064 E5A1              *                   os_flag
0065 E5A1              *
0066 E5A1              * Outputs:
0067 E5A1              *                   OS_flag
0068 E5A1              *
0069 E5A1              * External Refs:
0070 E5A1              *                   none
0071 E5A1              *
0072 E5A1              * Entry Points:
0073 E5A1              *                   none
0074 E5A1              *
0075 E5A1                       longa on                       ; mode
0076 E5A1                       longi on
0077 E5A1              *
0078 E5A1              * Change History
0079 E5A1              *
0080 E5A1              * 21 Nov 88         Steven Glass
0081 E5A1              *
0082 E5A1              * This call can be made before the OS is in the system and 
0083 E5A1              * the other silly code always installs a valid stack entry 
0084 E5A1              * point.  So we cannot relay on the $5C opcode being in the 
0085 E5A1              * stackentry point as a test for the existance of the OS.
0086 E5A1              *
0087 E5A1              * We check normal entry to see if it is $5c.  If it is not
0088 E5A1              * we exit right away.
0089 E5A1              *
0090 E5A1              * ?? ??? ??         Steven Glass
0091 E5A1              *
0092 E5A1              * We discovered that the OS did not set the OS Kind byte 
0093 E5A1              * from $FF to 1 until just before the application launched.
0094 E5A1              * this made it impossible to rely on the flag for boot time
0095 E5A1              * information.
0096 E5A1              *
0097 E5A1              * 25 Jan 89         Steven Glass
0098 E5A1              *
0099 E5A1              * But FF, at other times means we are in between p8 and 
0100 E5A1              * p16.  So it is not safe to make OS calls.
0101 E5A1              *
0102 E5A1              ****************************************************************
0103 E5A1
0104 E5A1
0105 E5A1              ;-----------------------------------------------------------
0106 E5A1              ;
0107 E5A1              ; Is there any OS in the system at this time?
0108 E5A1              ;
0109 E5A1 AF A8 00 E1           lda   >OS_Entry
0110 E5A5 29 FF 00              and   #$00FF
0111 E5A8 C9 5C 00              cmp   #$005C
0112 E5AB D0 0A                 bne   QuickExit
0113 E5AD
0114 E5AD              ;-----------------------------------------------------------
0115 E5AD              ;
0116 E5AD              ; See if we've been here before.
0117 E5AD              ;
0118 E5AD AF BE 00 E1           lda   >OS_Flag                 ; look at specialbit of os_flag
0119 E5B1 AA                    tax   
0120 E5B2 29 01 00              and   #SpecialBit
0121 E5B5 F0 01                 beq   Continue
0122 E5B7
0123 E5B7              QuickExit  
0124 E5B7 6B                    rtl   
0125 E5B8
0126 E5B8              Continue  
0127 E5B8              ;-----------------------------------------------------------
0128 E5B8              ;
0129 E5B8              ; If we've been through this before, and the OS is not
0130 E5B8              ; a bad OS, we can quit.
0131 E5B8              ;
0132 E5B8 8A                    txa   
0133 E5B9 89 08 00              bit   #PatchedOnceBit
0134 E5BC F0 05                 beq   StillAVirgin
0135 E5BE 89 02 00              bit   #BadOSBit
0136 E5C1 F0 F4                 beq   QuickExit
0137 E5C3
0138 E5C3
0139 E5C3              StillAVirgin  
0140 E5C3
0141 E5C3
0142 E5C3
0143 E5C3
0144 E5C3              ;--------------------------------------------------------------------------------
0145 E5C3              ;
0146 E5C3              ; Make sure that the right OS is available.
0147 E5C3              ;
0148 E5C3 AF BD 00 E1           lda   >OS_Boot                 ; first check to see what os has booted
0149 E5C7 29 FF 00              and   #$00FF
0150 E5CA C9 01 00              cmp   #$0001
0151 E5CD D0 E8                 bne   QuickExit
0152 E5CF
0153 E5CF AF BC 00 E1           lda   >OS_Kind                 ; second, see what os is active now
0154 E5D3 29 FF 00              and   #$00FF
0155 E5D6 C9 01 00              cmp   #$0001
0156 E5D9 F0 0B                 beq   OSIsP16
0157 E5DB
0158 E5DB C9 FF 00              cmp   #$00FF                   ; if not 1 or FF, cannot be P16 or GSOS
0159 E5DE D0 D7                 bne   QuickExit
0160 E5E0
0161 E5E0 8A                    txa                            ; if FF and the OS has been patched once
0162 E5E1 29 08 00              and   #PatchedOnceBit          ; then this is really the intermediate state
0163 E5E4 D0 D1                 bne   QuickExit                ; and we cannot continue
0164 E5E6
0165 E5E6              ;
0166 E5E6              ; If we get to here, then the OS_Kind is FF, and we have not been patched once.
0167 E5E6              ; That means that we've encountered the bug in the early OS's that the OS kind
0168 E5E6              ; byte was not set until just before the application was run.
0169 E5E6              ;
0170 E5E6
0171 E5E6              OSIsP16   
0172 E5E6 8A                    txa   
0173 E5E7 09 09 00              ora   #SpecialBit+PatchedOnceBit
0174 E5EA 8F BE 00 E1           sta   >OS_Flag                 ; set it so we won't do it again
0175 E5EE
0176 E5EE
0177 E5EE              ;-----------------------------------------------------------
0178 E5EE              ;
0179 E5EE              ; Make the version call using the stack entry  point.
0180 E5EE              ;
0181 E5EE              ;  Changed on 11/30/88 by Konstantin Othmer
0182 E5EE              ; Now the dbr is set to 0 since an old version of the OS (which EA World
0183 E5EE              ;  Tour Golf shipped with) assumes the dbr is 0
0184 E5EE              ;
0185 E5EE
0186 E5EE 8B                    phb                            ;save the dbr
0187 E5EF F4 00 00              pea   #0                       ;set it to 0
0188 E5F2 AB                    plb   
0189 E5F3 AB                    plb   
0190 E5F4
0191 E5F4 48                    pha                            ; push space on the stack for the parameter block
0192 E5F5 3B                    tsc                            ; push a pointer to that word on the stack
0193 E5F6 1A                    inc   a
0194 E5F7 F4 00 00              pea   0000
0195 E5FA 48                    pha   
0196 E5FB F4 2A 00              PushWord #$002A                ; push the version call number on the stack
0197 E5FE 22 B0 00 E1           jsl   OS_StackEntry            ; call the OS
0198 E602 68                    pla                            ; look at the version
0199 E603 AB                    plb                            ;set back to old dbr
0200 E604 29 FF 7F              and   #$7FFF                   ; make the proto versions work too.
0201 E607 C9 00 02              cmp   #$0200
0202 E60A D0 AB                 bne   QuickExit
0203 E60C
0204 E60C              ;-----------------------------------------------------------
0205 E60C              ;
0206 E60C              ; Set the bad os bit so other routines will know later that
0207 E60C              ; they may have something to do.
0208 E60C              ;
0209 E60C AF BE 00 E1           lda   >OS_Flag
0210 E610 09 02 00              ora   #BadOSBit
0211 E613 8F BE 00 E1           sta   >OS_Flag
0212 E617
0213 E617              ;-----------------------------------------------------------
0214 E617              ;
0215 E617              ; This is the version we must patch!  Make some direct
0216 E617              ; page space on the stack.
0217 E617              ;
0218 E617                       DefineStack 
0219 E617              OrigD    word 
0220 E617              Count    word 
0221 E617              Ptr      LONG 
0222 E617              DibPtr   LONG 
0223 E617
0224 E617
0225 E617 48                    pha                            ; space for the dib ptr
0226 E618 48                    pha   
0227 E619 AF 26 BD 00           lda   >Drvr_Dib_Ptr+2          ; the pointer to the dib list
0228 E61D 48                    pha   
0229 E61E AF 24 BD 00           lda   >Drvr_Dib_Ptr
0230 E622 48                    pha   
0231 E623 48                    pha                            ; space for the count
0232 E624 0B                    phd                            ; save d-reg
0233 E625 3B                    tsc                            ; turn stack into d-page
0234 E626 5B                    tcd   
0235 E627
0236 E627 A7 05                 lda   [ptr]                    ; move the count from list to d-page
0237 E629 F0 58                 beq   NoDevices
0238 E62B 85 03                 sta   Count
0239 E62D
0240 E62D A9 04 00              lda   #4
0241 E630 80 44                 bra   BumpPtr
0242 E632
0243 E632 A0 06 00     Loop     ldy   #DibEntry.UserID         ; The user ID must be zero
0244 E635 B7 05                 lda   [Ptr],y                  ; or its a loaded driver
0245 E637 D0 3A                 bne   NotThisOne
0246 E639
0247 E639 A0 02 00              ldy   #DibEntry.Ptr+2
0248 E63C B7 05                 lda   [Ptr],y
0249 E63E 85 0B                 sta   DibPtr+2
0250 E640 88                    dey   
0251 E641 88                    dey   
0252 E642 B7 05                 lda   [Ptr],y
0253 E644 85 09                 sta   DibPtr
0254 E646
0255 E646              ;-----------------------------------------------------------
0256 E646              ;
0257 E646              ; Make sure all the conditions in the CheckTable are met.
0258 E646              ;
0259 E646 A2 00 00              ldx   #0
0260 E649 BF 8A E6 FC  @CheckLoop lda   >CheckTable,x
0261 E64D A8                    tay   
0262 E64E B7 09                 lda   [DibPtr],y
0263 E650 DF 8C E6 FC           cmp   >CheckTable+2,x
0264 E654 D0 1D                 bne   NotThisOne
0265 E656 E8                    inx   
0266 E657 E8                    inx   
0267 E658 E8                    inx   
0268 E659 E8                    inx   
0269 E65A E0 1C 00              cpx   #NumItemsToCheck
0270 E65D 90 EA                 bcc   @CheckLoop
0271 E65F
0272 E65F              ;-----------------------------------------------------------
0273 E65F              ;
0274 E65F              ; Make sure the unit number is not 1
0275 E65F
0276 E65F A0 30 00              ldy   #DIBRecord.unit_num      ; this must be other than 1
0277 E662 B7 09                 lda   [DibPtr],y
0278 E664 C9 01 00              cmp   #1
0279 E667 F0 0A                 beq   NotThisOne
0280 E669
0281 E669              ;-----------------------------------------------------------
0282 E669              ;
0283 E669              ; Yup, this is the one to patch!
0284 E669              ;
0285 E669
0286 E669 A9 02 00              lda   #2                       ; make unit num 2
0287 E66C A0 4A 00              ldy   #DIBRecord.hw_unit_num
0288 E66F 97 09                 sta   [DibPtr],y
0289 E671 80 10                 bra   NoDevices                ; cannot be more than one to patch
0290 E673
0291 E673              NotThisOne  
0292 E673 A9 08 00              lda   #8
0293 E676 18           BumpPtr  clc   
0294 E677 65 05                 adc   ptr
0295 E679 85 05                 sta   ptr
0296 E67B 90 02                 bcc   @1
0297 E67D E6 07                 inc   ptr+2
0298 E67F              @1        
0299 E67F C6 03                 dec   Count
0300 E681 10 AF                 bpl   Loop
0301 E683
0302 E683
0303 E683
0304 E683              NoDevices  
0305 E683 2B                    pld   
0306 E684 68                    pla   
0307 E685 68                    pla   
0308 E686 68                    pla   
0309 E687 68                    pla   
0310 E688 68                    pla   
0311 E689
0312 E689
0313 E689
0314 E689
0315 E689
0316 E689
0317 E689              ;-----------------------------------------------------------
0318 E689              ;
0319 E689              ; All done.
0320 E689
0321 E689
0322 E689 6B                    rtl   
0323 E68A
0324 E68A
0325 E68A
0326 E68A
0327 E68A              ;-----------------------------------------------------------
0328 E68A              ;
0329 E68A              ; CheckTable
0330 E68A              ;
0331 E68A              ; Contains an offset in the dibRecord and the value
0332 E68A              ; that must be at that offset.
0333 E68A              ;
0334 E68A              ; For example the dev_char field must be $43EC.
0335 E68A              ;
0336 E68A              CheckTable  
0337 E68A 08 00 EC 43           DC W:DIBRecord.dev_char,$43EC
0338 E68E 2E 00 05 00           DC W:DIBRecord.slot_num,$0005
0339 E692 34 00 03 00           DC W:DIBRecord.dev_id_num,3
0340 E696 40 00 02 00           DC W:DIBRecord.drvr_class,0002
0341 E69A 42 00 01 00           DC W:DIBRecord.drvr_type,0001
0342 E69E 44 00 C0 00           DC W:DIBRecord.drvr_subtype,$00C0
0343 E6A2 4A 00 01 00           DC W:DIBRecord.hw_unit_num,1
0344 E6A6
0345 E6A6              NumItemsToCheck equ   *-CheckTable
0346 E6A6
0347 E6A6                       ENDP 
0348 E6A6
0349 E6A6
0350 E6A6
0351 E6A6                       END   
